*********************************************************
* This program uses output from Rage-Rgequate to create *
*   graphs like those in Figure 3.6 on page 91 of Kolen *
*   and Brennan (the example data is from the example   *
*   file input.dat).  This program will work with any   *
*   set of S values.  You must indicate the number of S *
*   levels you used and specify the specific S values.  *
*   Paste in your output where indicated.               *
*                                     -Brett Foley      *
*********************************************************;
*********************************************************
* Minor changes have been made from Brett's orignal SAS *
*   codes such that the final codes could be generated  *
*   by Rage-Rgequate automatically.                     *
*                                     -Zhongmin Cui     *
*********************************************************;

*------------------------------------* 
| Enter the number of S levels here. |
*------------------------------------*;
%LET numlevels = 
9
;

*------------------------------------*
| Enter the S values here (separated |
|   by spaces).                      |
*------------------------------------*;
%LET levels = 
 0.01  0.05  0.10  0.20  0.30  0.40  0.50  0.75  1.00 
;


*-----------------------------------------------------*
| Paste Raw-to-Raw Score Conversion for Postsmoothing |
|   output here. (after "datalines" command)          |
*-----------------------------------------------------*;
data postplots;
input XScore SE  NoSmooth s1-s&numlevels linear; 
datalines;

         0    1.4142     0.000     0.013     0.013     0.013     0.013     0.013     0.013     0.013     0.013     0.013     0.992
         1    0.0001     1.000     1.038     1.038     1.038     1.038     1.038     1.038     1.038     1.038     1.038     1.960
         2    0.0001     2.000     2.063     2.063     2.063     2.063     2.063     2.063     2.063     2.063     2.063     2.927
         3 2830.8869     3.000     3.089     3.089     3.089     3.089     3.089     3.089     3.089     3.089     3.089     3.895
         4 1778.7208     4.000     4.114     4.114     4.114     4.114     4.114     4.114     4.114     4.114     4.114     4.863
         5 1110.5894     5.038     5.139     5.139     5.139     5.139     5.139     5.139     5.139     5.139     5.139     5.831
         6  695.0304     6.066     6.165     6.165     6.165     6.165     6.165     6.165     6.165     6.165     6.165     6.799
         7  468.0034     7.088     7.190     7.190     7.190     7.190     7.190     7.190     7.190     7.190     7.190     7.767
         8  326.2941     8.100     8.215     8.215     8.215     8.215     8.215     8.215     8.215     8.215     8.215     8.734
         9  238.7082     9.107     9.241     9.241     9.241     9.241     9.241     9.241     9.241     9.241     9.241     9.702
        10  180.3813    10.111    10.266    10.266    10.266    10.266    10.266    10.266    10.266    10.266    10.266    10.670
        11  140.7495    11.113    11.291    11.291    11.291    11.291    11.291    11.291    11.291    11.291    11.291    11.638
        12  112.6765    12.114    12.317    12.317    12.317    12.317    12.317    12.317    12.317    12.317    12.317    12.606
        13   92.3394    13.114    13.342    13.342    13.342    13.342    13.342    13.342    13.342    13.342    13.342    13.573
        14   77.2097    14.113    14.367    14.367    14.367    14.367    14.367    14.367    14.367    14.367    14.367    14.541
        15   65.7276    15.111    15.393    15.393    15.393    15.393    15.393    15.393    15.393    15.393    15.393    15.509
        16   56.8494    16.109    16.418    16.418    16.418    16.418    16.418    16.418    16.418    16.418    16.418    16.477
        17   49.8730    17.106    17.431    17.431    17.431    17.431    17.431    17.431    17.431    17.431    17.431    17.445
        18   44.3131    18.103    18.399    18.399    18.399    18.399    18.399    18.399    18.399    18.399    18.399    18.413
        19   39.8251    19.100    19.367    19.367    19.367    19.367    19.367    19.367    19.367    19.367    19.367    19.380
        20   36.1635    20.097    20.334    20.334    20.334    20.334    20.334    20.334    20.334    20.334    20.334    20.348
        21   33.1467    21.093    21.302    21.302    21.302    21.302    21.302    21.302    21.302    21.302    21.302    21.316
        22   30.6390    22.090    22.270    22.270    22.270    22.270    22.270    22.270    22.270    22.270    22.270    22.284
        23   28.5387    23.086    23.237    23.237    23.237    23.237    23.237    23.237    23.237    23.237    23.237    23.252
        24   26.7663    24.082    24.205    24.205    24.205    24.205    24.205    24.205    24.205    24.205    24.205    24.219
        25   25.2616    25.077    25.173    25.173    25.173    25.173    25.173    25.173    25.173    25.173    25.173    25.187
        26   23.9764    26.071    26.141    26.141    26.141    26.141    26.141    26.141    26.141    26.141    26.141    26.155
        27   22.8726    27.065    27.108    27.108    27.108    27.108    27.108    27.108    27.108    27.108    27.108    27.123
        28   21.9199    28.057    28.076    28.076    28.076    28.076    28.076    28.076    28.076    28.076    28.076    28.091
        29   21.0939    29.048    29.044    29.044    29.044    29.044    29.044    29.044    29.044    29.044    29.044    29.059
        30   20.3749    30.037    30.011    30.011    30.011    30.011    30.011    30.011    30.011    30.011    30.011    30.026
        31   19.7467    31.024    30.979    30.979    30.979    30.979    30.979    30.979    30.979    30.979    30.979    30.994
        32   19.1966    32.008    31.947    31.947    31.947    31.947    31.947    31.947    31.947    31.947    31.947    31.962
        33   18.7144    32.990    32.915    32.915    32.915    32.915    32.915    32.915    32.915    32.915    32.915    32.930
        34   18.2920    33.969    33.882    33.882    33.882    33.882    33.882    33.882    33.882    33.882    33.882    33.898
        35   17.9233    34.946    34.850    34.850    34.850    34.850    34.850    34.850    34.850    34.850    34.850    34.865
        36   17.6040    35.919    35.818    35.818    35.818    35.818    35.818    35.818    35.818    35.818    35.818    35.833
        37   17.3312    36.889    36.785    36.785    36.785    36.785    36.785    36.785    36.785    36.785    36.785    36.801
        38   17.1035    37.857    37.753    37.753    37.753    37.753    37.753    37.753    37.753    37.753    37.753    37.769
        39   16.9207    38.821    38.721    38.721    38.721    38.721    38.721    38.721    38.721    38.721    38.721    38.737
        40   16.7841    39.782    39.689    39.689    39.689    39.689    39.689    39.689    39.689    39.689    39.689    39.705
        41   16.6960    40.741    40.656    40.656    40.656    40.656    40.656    40.656    40.656    40.656    40.656    40.672
        42   16.6602    41.697    41.624    41.624    41.624    41.624    41.624    41.624    41.624    41.624    41.624    41.640
        43   16.6816    42.651    42.592    42.592    42.592    42.592    42.592    42.592    42.592    42.592    42.592    42.608
        44   16.7668    43.604    43.559    43.559    43.559    43.559    43.559    43.559    43.559    43.559    43.559    43.576
        45   16.9241    44.554    44.527    44.527    44.527    44.527    44.527    44.527    44.527    44.527    44.527    44.544
        46   17.1637    45.503    45.495    45.495    45.495    45.495    45.495    45.495    45.495    45.495    45.495    45.512
        47   16.3886    46.454    46.462    46.462    46.462    46.462    46.462    46.462    46.462    46.462    46.462    46.479
        48   16.4910    47.406    47.430    47.430    47.430    47.430    47.430    47.430    47.430    47.430    47.430    47.447
        49   16.6770    48.359    48.398    48.398    48.398    48.398    48.398    48.398    48.398    48.398    48.398    48.415
        50   16.9589    49.312    49.366    49.366    49.366    49.366    49.366    49.366    49.366    49.366    49.366    49.383
        51   17.3522    50.267    50.333    50.333    50.333    50.333    50.333    50.333    50.333    50.333    50.333    50.351
        52   17.8766    51.224    51.301    51.301    51.301    51.301    51.301    51.301    51.301    51.301    51.301    51.318
        53   18.5576    52.183    52.269    52.269    52.269    52.269    52.269    52.269    52.269    52.269    52.269    52.286
        54   19.4283    53.145    53.236    53.236    53.236    53.236    53.236    53.236    53.236    53.236    53.236    53.254
        55   20.5327    54.110    54.204    54.204    54.204    54.204    54.204    54.204    54.204    54.204    54.204    54.222
        56   21.9299    55.078    55.172    55.172    55.172    55.172    55.172    55.172    55.172    55.172    55.172    55.190
        57   23.7009    56.049    56.140    56.140    56.140    56.140    56.140    56.140    56.140    56.140    56.140    56.158
        58   25.9580    57.025    57.107    57.107    57.107    57.107    57.107    57.107    57.107    57.107    57.107    57.125
        59   28.8630    58.006    58.075    58.075    58.075    58.075    58.075    58.075    58.075    58.075    58.075    58.093
        60   32.6515    58.992    59.047    59.047    59.047    59.047    59.047    59.047    59.047    59.047    59.047    59.061
        61   37.6833    59.985    60.174    60.174    60.174    60.174    60.174    60.174    60.174    60.174    60.174    60.029
        62   44.5196    60.986    61.301    61.301    61.301    61.301    61.301    61.301    61.301    61.301    61.301    60.997
        63   54.0858    61.997    62.428    62.428    62.428    62.428    62.428    62.428    62.428    62.428    62.428    61.964
        64   68.0229    63.019    63.555    63.555    63.555    63.555    63.555    63.555    63.555    63.555    63.555    62.932
        65   89.3406    64.057    64.682    64.682    64.682    64.682    64.682    64.682    64.682    64.682    64.682    63.900
        66  124.0586    65.116    65.809    65.809    65.809    65.809    65.809    65.809    65.809    65.809    65.809    64.868
        67  183.4597    66.224    66.936    66.936    66.936    66.936    66.936    66.936    66.936    66.936    66.936    65.836;
run;


*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*
!        Do not alter code below this point!      !
*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*;



*This reformats the data (tall format);
data postplots_reformatted; set postplots;

array testarray1 [&numlevels] s1-s&numlevels;
array testarray2 [&numlevels] sx1-sx&numlevels;
array x1[&numlevels] y1-y&numlevels (&levels);

do i = 1 to &numlevels;
    testarray2[i] = testarray1[i]-xscore;
end;

NoSmoothe= NoSmooth - XScore;
lineare= linear-XScore;
SElow = (NoSmooth - SE) - XScore;
SEhi  = (NoSmooth + SE) - XScore;

do i = 1 to &numlevels;
slevel=i; eqdiff=testarray2[i]; S_Value = x1[i]; output;
end;
keep xscore slevel eqdiff NoSmoothe SEhi SElow S_Value;
run;


*This deletes the contents of the default graphics catalog work.gseg;
proc greplay nofs igout=work.gseg; delete _all_; run; quit;

*This creates axis labels;
axis1 label = (font=swiss height=1 'Raw Score Form X');
axis2 label = (angle=90 font=swiss height=1 'Form Y Equivalent Minus Form X Score');

*This sets up legends for the graphs;
legend1 label=none
        shape=symbol(7,1)
        position=(top center inside)
		value=('Smoothed' 'Unsmoothed' '+1 S.E.' '-1 S.E.')
        mode=share;


*******************************************
* This prints 1 graph per page (looks best*
*   printed in landscape format)          *
*******************************************;
proc sort; by S_Value; run;

options nobyline;
proc gplot data=postplots_reformatted;
   by S_Value;
   plot eqdiff*xscore NoSmoothe*xscore SEhi*xscore SElow*xscore
        /overlay haxis=axis1 vaxis=axis2 VREF = 0 legend=legend1;
        symbol1 color=red   i=line v=dot h=1;
		symbol2 color=black i=line v=triangle h=1;
		symbol3 color=blue i=line line=3 h=1;
		symbol4 color=green i=line line=3 h=1;
        title 'Raw-to-raw equivalents for postsmoothing, S = #byval(S_Value)';
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (4 graphs per page), print in    *
*  landscape format.                      *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup4graphs;
    %if (&numlevels LE 4) %then %do;
        treplay 1:Gplot  2:Gplot1 3:Gplot2 4:Gplot3; 
    %end;
    %else %if (&numlevels LE 8) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2 4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6 4:Gplot7;
	%end;
	%else %if (&numlevels LE 12) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6  4:Gplot7;
        treplay 1:Gplot8  2:Gplot9 3:Gplot10 4:Gplot11;
    %end;
	%else %if (&numlevels LE 16) %then %do;
        treplay 1:Gplot    2:Gplot1  3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4   2:Gplot5  3:Gplot6  4:Gplot7;
		treplay 1:Gplot8   2:Gplot9  3:Gplot10 4:Gplot11;
		treplay 1:Gplot12  2:Gplot13 3:Gplot14 4:Gplot15;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp1 des='Four per page'
   1/llx=0 lly=51
     ulx=0 uly=100
     urx=49 ury=100
     lrx=49 lry=51
     color=white
   2/llx=51 lly=51
     ulx=51 uly=100
     urx=100 ury=100
     lrx=100 lry=51
     color=white
   3/llx=0 lly=0
     ulx=0 uly=49
     urx=49 ury=49
     lrx=49 lry=0
     color=white
   4/llx=51 lly=0
     ulx=51 uly=49
     urx=100 ury=49
     lrx=100 lry=0
     color=white;

   template= newtemp1;

   %setup4graphs;
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (8 graphs per page), print in    *
*  portrait format.                       *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup8graphs;
    %if (&numlevels LE 8) %then %do;
        treplay 1:Template  2:Templat1;
	%end;
    %else %if (&numlevels LE 12) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2;
	%end;
	%else %if (&numlevels LE 16) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2  2:Templat3;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp2 des='Two per page'
   1/llx=0 lly=50.5
     ulx=0 uly=100
     urx=100 ury=100
     lrx=100 lry=50.5
     color=white
   2/llx=0 lly=0
     ulx=0 uly=49.5
     urx=100 ury=49.5
     lrx=100 lry=0
     color=white;

   template = newtemp2;

   %setup8graphs;
run; quit;





